/*
 *
 * Created: 27.01.2022
 * Version: 1.01
 * Author : Joerg Bischof (DM6RAC)
 */ 

#include <avr/io.h>
#include <util/delay.h> 
#include <avr/interrupt.h>

#define pause _delay_ms(3*punkt)
#define p_zw_zeichen _delay_ms(1000)
#define tastPort DDRB
#define tastBit DDB1

uint8_t const punkt = 75;
uint8_t anzahl, kennung, warte, dauer = 0;
uint8_t timerFlag = 1;
uint8_t en = 0;
uint8_t zaehler = 1;							
uint8_t anzDurchlauf = 20;
uint8_t counterStart = 200;
uint16_t warteZeit = 0;
uint16_t scaleFactor = 500;
uint16_t z = 0;


void taktHalbe(void)
{
	//*** OCR-Modus for f/2 ***//
	DDRB |= (1<<DDB1);								// OC1A output
	
	OCR1A = 0x00;									// Compare match = 0
	TCCR1A = (1<<COM1A0);							// Toggle OC1A on Compare Match
	TCCR1B = (1<<WGM12) + (1<<CS10);				// Mode 4, CTC on OCRA0A and Prescaler = 1
	//*** End of OCR-Modus ***//
}

void zeichen(char buchstabe) 
{
	switch (buchstabe)
	{
		case 'm':
			for (uint8_t i=0; i<2; i++) 
			{
				if (en) tastPort |= (1<<tastBit);
				PORTC |= (1<<DDC3);
				_delay_ms(3*punkt);
				tastPort &= ~(1<<tastBit);
				PORTC &= ~(1<<DDC3);
				_delay_ms(punkt);
			}
			break;
		case 'o':
			for (uint8_t i=0; i<3; i++) 
			{
				if (en) tastPort |= (1<<tastBit);
				PORTC |= (1<<DDC3);
				_delay_ms(3*punkt);
				tastPort &= ~(1<<tastBit);
				PORTC &= ~(1<<DDC3);
				_delay_ms(punkt);
			}
			break;
		case 'e':
			if (en) tastPort |= (1<<tastBit);
			PORTC |= (1<<DDC3);
			_delay_ms(punkt);
			tastPort &= ~(1<<tastBit);
			PORTC &= ~(1<<DDC3);
			_delay_ms(punkt);
			break;
		case 'i':
			for (uint8_t i=0; i<2; i++) 
			{
				if (en) tastPort |= (1<<tastBit);
				PORTC |= (1<<DDC3);
				_delay_ms(punkt);
				tastPort &= ~(1<<tastBit);
				PORTC &= ~(1<<DDC3);
				_delay_ms(punkt);
			}
			break;
		case 's':
			for (uint8_t i=0; i<3; i++) 
			{
				if (en) tastPort |= (1<<tastBit);
				PORTC |= (1<<DDC3);
				_delay_ms(punkt);
				tastPort &= ~(1<<tastBit);
				PORTC &= ~(1<<DDC3);
				_delay_ms(punkt);
			}
			break;
		case 'h':
			for (uint8_t i=0; i<4; i++) 
			{
				if (en) tastPort |= (1<<tastBit);
				PORTC |= (1<<DDC3);
				_delay_ms(punkt);
				tastPort &= ~(1<<tastBit);
				PORTC &= ~(1<<DDC3);
				_delay_ms(punkt);
			}
			break;
		case '5':
			for (uint8_t i=0; i<5; i++) 
			{
				if (en) tastPort |= (1<<tastBit);
				PORTC |= (1<<DDC3);
				_delay_ms(punkt);
				tastPort &= ~(1<<tastBit);
				PORTC &= ~(1<<DDC3);
				_delay_ms(punkt);
			}
			break;
	}
}
void mo(void) 
{
	zeichen('m');
	pause;
	zeichen('o');
	pause;

}

void mox(char b)
{
	mo();
	zeichen(b);
	p_zw_zeichen;
}

void txAnzeige(void)
{
	if (en == 1)
	{
		PORTC |= (1<<DDC5);
	} 
	else
	{
		PORTC &= ~(1<<DDC5);
	}
}

void tastung(void)
{
	en = (kennung == 1)?1:0;
	txAnzeige();
	if (zaehler <= anzahl)
	{
		for (uint8_t i = 0; i < anzDurchlauf; i++)
		{
			mox('e');
		}
	}
	else
	{
		zaehler = 1;
		return;
	}
	en = (kennung == 2)?1:0;
	txAnzeige();
	zaehler++;
	if (zaehler <= anzahl)
	{
		for (uint8_t i = 0; i < anzDurchlauf; i++)
		{
			mox('i');
		}
	}
	else
	{
		zaehler = 1;
		return;
	}
	en = (kennung == 3)?1:0;
	txAnzeige();
	zaehler++;
	if (zaehler <= anzahl)
	{
		for (uint8_t i = 0; i < anzDurchlauf; i++)
		{
			mox('s');
		}
	}
	else
	{
		zaehler = 1;
		return;
	}
	en = (kennung == 4)?1:0;
	txAnzeige();
	zaehler++;
	if (zaehler <= anzahl)
	{
		for (uint8_t i = 0; i < anzDurchlauf; i++)
		{
			mox('h');
		}
	}
	else
	{
		zaehler = 1;
		return;
	}
	en = (kennung == 5)?1:0;
	txAnzeige();
	zaehler++;
	if (zaehler <= anzahl)
	{
		for (uint8_t i = 0; i < anzDurchlauf; i++)
		{
			mox('5');
		}
	}
	else
	{
		zaehler = 1;
		return;
	}
}

void init_timer_2(void)
{
	TCCR2A = 0x00;									// OC2A und OC2B disconnected; Normal Mode
	TCCR2B = (1<<CS22)|(1<<CS21);					// Prescaler = 256
	TIMSK2 = (1<<TOIE2);							// interrupt, wenn TCNT2 ueberlaeuft
	TCNT2 = counterStart;							// Voreinstellung Counter
} 

int main(void)
{
	DDRD = 0x00;									// Port D Input
	PORTD = 0xFF;									// Pull-Up on
	DDRB &= ~(1<<DDB2);								// PB2 Input for switch S4
	PORTB |= (1<<DDB2);								// PB2 Pull-Up on
	
	uint16_t adcV;

	DDRC |= 0x3E;									// DDC1 ... DDC5 Output

	//*** init ADC ***
	ADCSRA |= (1<<ADEN);							// ADC aktivieren
	ADCSRA |= (1<<ADPS1)|(1<<ADPS2);				// Vorteiler auf 64
	ADMUX  |= (1<<REFS0);							// Uref = AVcc
	ADMUX  &= ~((1<<MUX2)|(1<<MUX1)|(1<<MUX0));		// ADC Kanal 0 (ADC0, Pin 23)
	DIDR0  |= (1<<ADC0D);							// dig. Input Kanal ADC0 deaktivieren
	// *** End init ADC ***

	init_timer_2();									// init 1-s-Timer
	sei();											// enable Interrupts
	taktHalbe();									// halber Takt an PB1
	
    while (1) 
    {
		/* 
		* Es wird immer der gesamte Port ausgelesen. Da gegen Masse geschaltet
		* wird (LOW-aktiv), muessen die einzelnen Bits negiert werden (es sollen ja 
		* die 1en ausgewertet werden). Es sollen aber immer nur einzelne Teile des Ports 
		* ausgewertet werden. Deshalb wird eine Maske UND-Verknuepft, die die nicht benoetigten
		* Bits auf 0 setzt. Durch eine Rechtsverschiebung wird erreicht, dass immer von Bit 0 
		* begonnen werden kann auszuwerten.
		*/ 
		// *** Kennung (Nr.) des aktuellen Senders ***
		kennung = ~PIND & 0xE0;						// Maske PD5 ... PD7
		kennung = kennung >> 5;						// 5 Stellen nach rechts

		// *** Wartezeit ***
		warte = ~PIND & 0x18;						// Maske PD3 und PD4
		warte = warte >> 3;							// 3 Stellen nach rechts

		// *** Anzahl der Sender insgesammt ***
		anzahl = ~PIND & 0x07;						// Maske PD0 ... PD2 (verschieben nicht noetig)

		dauer = ~PINB & 0x04;						// Abfrage S4
		dauer = dauer >> 2;

		if (timerFlag)
			{switch (warte)
			{
				case 1:
				warteZeit = 1200;						// 20 min.
				timerFlag = 0;
				break;
				case 2:
				warteZeit = 1800;						// 30 min.
				timerFlag = 0;
				break;
				case 3:
				warteZeit = 2700;						// 45 min.
				timerFlag = 0;
				break;
				default:
				warteZeit = 0;
				timerFlag = 1;
				break;
			}
		}

		tastPort &= ~(1<<tastBit);					// TX aus

		if (z >= warteZeit) tastung();

		if (dauer == 1)								// wenn S4 on
		{
			tastPort |= (1<<tastBit);				// TX dauersenden

			ADCSRA |= (1<<ADSC);					// start ADC-Wandlung
			while (ADCSRA &(1<<ADSC));				// auf Abschluss der Konvertierung warten
			adcV = ADC;								// Ergebnis in adcV (16 Bit)
			
			if (adcV > 0x0B8) PORTC |= (1<<DDC1);	// 0,9 V
			if (adcV > 0x170) PORTC |= (1<<DDC2);	// 1,9 V
			if (adcV > 0x229) PORTC |= (1<<DDC3);	// 2,7 V
			if (adcV > 0x2E1) PORTC |= (1<<DDC4);	// 3,6 V
			if (adcV > 0x39A) PORTC |= (1<<DDC5);	// 4,5 V
			
			PORTC &= 0xC0;							// Pins wieder zuruecksetzen
		}
    }
}

ISR(TIMER2_OVF_vect)
{
	static uint16_t counter = 0;
	TCNT2 = counterStart;
	counter++;
	if (counter == scaleFactor)
	{
		z++;
		counter = 0;
	}
}